![](https://ask.qcloudimg.com/http-save/1752328/uskvyzme4j.png)

在上一篇中,我们谈到过

```
程序的CPU执行时间 = 指令数×CPI×Clock Cycle Time
```

要提升计算机的性能，可以从上面这三方面着手。

通过指令数/CPI，好像都太难了。

因此工程师们，就在CPU上多放晶体管，不断提升CPU的时钟频率，让CPU更快，程序的执行时间就会缩短。

![](https://ask.qcloudimg.com/http-save/1752328/09hlntlacb.png)

- 从1978年Intel发布的8086 CPU开始，计算机的主频从5MHz开始，不断攀升
- 1980年代中期的80386能够跑到40MHz
- 1989年的486能够跑到100MHz
- 直到2000年的奔腾4处理器，主频已经到达了1.4GHz

# 1 功耗：CPU的“人体极限”

[奔腾4的CPU主频从来没有达到过10GHz，最终它的主频上限定格在3.8GHz](https://zh.wikipedia.org/wiki/%25E5%25A5%2594%25E8%2585%25BE4)

而且奔腾4的主频虽然高，但是实际性能却配不上同样的主频

想要用在笔记本上的奔腾4 2.4GHz处理器，其性能只和基于奔腾3架构的奔腾M 1.6GHz匹配

于是不仅让Intel的对手AMD获得了喘息之机，更是代表着“主频时代”的终结。

后面几代Intel CPU主频不但没有上升，反而下降了。

到如今，2019年的最高配置[Intel i9 CPU](https://zh.wikipedia.org/wiki/Intel_Core_i9)，主频也不过是5GHz

相较于1978年到2000年，这20年里300倍的主频提升，从2000年到现在的这19年，CPU的主频大概提高了3倍

- CPU的主频变化，奔腾4时进入瓶颈期![](https://ask.qcloudimg.com/http-save/1752328/mxpvmi6gzl.png)

奔腾4的主频为什么没能超3.8GHz？

就因为功耗.

一个3.8GHz的奔腾4处理器，满载功率是130瓦

130瓦是什么概念呢？机场允许带上飞机的充电宝的容量上限是100瓦时

如果我们把这个CPU安在手机里面，不考虑屏幕内存之类的耗电，这个CPU满载运行45分钟，充电宝里面就没电了

而iPhone X使用ARM架构的CPU，功率则只有4.5瓦左右。

CPU，也称作**超大规模集成电路（Very-Large-Scale Integration，VLSI** 

由一个个晶体管组成

CPU的计算过程，其实就是让晶体管里面的“开关”不断“打开”/“关闭”，组合完成各种运算和功能。

要想算得快

- 增加密度
在CPU同样的面积，多放晶体管
- 提升主频
让晶体管“打开”/“关闭”得快点

这两者，都会增加功耗，带来耗电和散热的问题!!!

可以把CPU想象成一个工厂，有很多工人

就如CPU上面的晶体管，互相之间协同工作。

为了工作快点完成，在工厂里多塞一点人

你可能会问，为什么不把工厂造得大点？

这是因为，人和人之间如果离得远了，互相之间走过去需要花的时间就会变长，这也会导致性能下降!

这就如如果CPU的面积大，晶体管之间的距离变大，电信号传输的时间就会变长，运算速度自然就慢了。

除了多塞一点人，还希望每个人动作快点，同样时间就可多干活了

这就相当于提升CPU主频，但是动作快，每个人就要出汗散热

要是太热了，对工厂里面的人来说会休克，对CPU来说就会崩溃出错。

我们会在CPU上面抹硅脂、装风扇，乃至用上水冷或者其他更好的散热设备

就好像在工厂里面装风扇、空调，发冷饮一样

但是同样的空间下，装上风扇空调能够带来的散热效果也是有极限的

因此，在CPU里面，能够放下的晶体管数量和晶体管的“开关”频率也都是有限的。

一个CPU的功率，可以用这样一个公式来表示：

```
功耗  ≈ 1/2 ×负载电容 × 电压的平方 × 开关频率 × 晶体管数量
```

为了提升性能，要不断地增加晶体管数量

同样的面积下，想要多放一点晶体管，就要把晶体管造得小一点

这个就是平时我们所说的提升“制程”

从28nm到7nm，相当于晶体管本身变成了原来的1/4大小

这个就相当于我们在工厂里，同样的活儿，我们要找瘦小一点的工人，这样一个工厂里面就可以多一些人

我们还要提升主频，让开关的频率变快，也就是要找手脚更快的工人

![](https://ask.qcloudimg.com/http-save/1752328/4r5uwxufnv.png)

但功耗增加过多，CPU散热就跟不上

这时就需要降低电压

这里有一点非常关键，在整个功耗的公式里面，功耗和电压的平方是成正比的

这意味着电压下降到原来的1/5，整个的功耗会变成原来的1/25。

事实上，从5MHz主频的8086到5GHz主频的Intel i9，CPU的电压已经从5V左右下降到了1V左右

这也是为什么我们CPU的主频提升了1000倍，但是功耗只增长了40倍

# 2 并行优化 - 阿姆达尔定律

虽然制程的优化和电压的下降，在过去的20年里，让CPU性能有所提升

但是从上世纪九十年代到本世纪初，软件工程师们所用的“面向摩尔定律编程”的套路越来越用不下去了

“写程序不考虑性能，等明年CPU性能提升一倍，到时候性能自然就不成问题了”，这种想法已经不可行了。

于是，从奔腾4开始，Intel意识到通过提升主频比较“难”去实现性能提升

开始推出Core Duo这样的多核CPU，通过提升“吞吐率”而不是“响应时间”，来达到目的。

提升响应时间，就好比提升你用的交通工具的速度

原本你是开汽车，现在变成了高铁乃至飞机

但是，在此之上，再想要提升速度就不太容易了

CPU在奔腾4的年代，就好比已经到了飞机这个速度极限

那你可能要问了，接下来该怎么办呢？

相比于给飞机提速，工程师们又想到了新的办法，可以一次同时开2架、4架乃至8架飞机，这就好像我们现在用的2核、4核，乃至8核的CPU。

虽然从上海到北京的时间没有变，但是一次飞8架飞机能够运的东西自然就变多了，也就是所谓的“吞吐率”变大了。所以，不管你有没有需要，现在CPU的性能就是提升了2倍乃至8倍、16倍。

这也是一个最常见的提升性能的方式，**通过并行提高性能**。

这个思想在很多地方都可以使用

举个例子，我们做机器学习程序的时候，需要计算向量的点积，比如向量

```
$W = [W_0, W_1, W_2, …, W_{15}]$
```

和向量

```
$X = [X_0, X_1, X_2, …, X_{15}]$
```

```
$W·X = W_0 * X_0 + W_1 * X_1 +$
```

```
$W_2 * X_2 + … + W_{15} * X_{15}$
```

这些式子由16个乘法和1个连加组成。如果你自己一个人用笔来算的话，需要一步一步算16次乘法和15次加法。

如果这个时候我们把这个人物分配给4个人，同时去算$W_0～W\_3$, $W\_4～W\_7$, $W\_8～W_{11}$, $W_{12}～W_{15}$这样四个部分的结果，再由一个人进行汇总，需要的时间就会缩短。

![](https://ask.qcloudimg.com/http-save/1752328/z6nx9lsihq.png)

但并不是所有问题，都可以通过并行提高性能来解决

要使用这种思想，需要满足以下条件:

- 需要进行的计算，本身可以分解成几个可以并行的任务
好比上面的乘法和加法计算，几个人可以同时进行，不会影响最后的结果。
- 需要能够分解好问题，并确保几个人的结果能够汇总到一起
- 在“汇总”这个阶段，是没有办法并行进行的，还是得顺序执行，一步一步来。

这就引出了性能优化中一个经验定律

- 阿姆达尔定律（Amdahl’s Law）
对于一个程序进行优化之后，处理器并行运算之后效率提升的情况

具体可以用这样一个公式来表示：

```
优化后的执行时间 = 受优化影响的执行时间/加速倍数+不受影响的执行时间
```

在刚刚的向量点积例子里，4个人同时计算向量的一小段点积，就是通过并行提高了这部分的计算性能

但是，这4个人的计算结果，最终还是要在一个人那里进行汇总相加

这部分汇总相加的时间，是不能通过并行来优化的，也就是上面的公式里面**不受影响的执行时间**部分

比如上面的各个向量的一小段

- 点积，需要100ns
- 加法需要20ns

总共需要120ns。这里通过并行4个CPU有了4倍的加速度。那么最终优化后，就有了100/4+20=45ns

即使我们增加更多的并行度来提供加速倍数，比如有100个CPU，整个时间也需要100/100+20=21ns。

![](https://ask.qcloudimg.com/http-save/1752328/m00nhlporg.png)

# 3 总结

无论是简单地通过提升主频，还是增加更多的CPU核心数量，通过并行提升性能，都会遇到相应的瓶颈

仅靠简单地通过“堆硬件”的方式，在今天已经不能很好地满足我们对于程序性能的期望了。

于是，工程师们需要从其他方面开始下功夫了。

在“摩尔定律”和“并行计算”之外，在整个计算机组成层面，还有这样几个原则性的性能提升方法。

## 3.1 加速大概率事件

深度学习，整个计算过程中，99%都是向量和矩阵计算

于是，工程师们通过用GPU替代CPU，大幅度提升了深度学习的模型训练过程

本来一个CPU需要跑几小时甚至几天的程序，GPU只需要几分钟就好了

Google更是不满足于GPU的性能，进一步地推出了TPU

> 通常我们使用 O 表示一个算法的好坏，我们优化一个算法也是基于 big-O
> 但是 big-O 其实是一个近似值，就好比一个算法时间复杂度是 O(n^2) + O(n)
> 这里的 O(n^2) 是占大比重的，特别是当 n 很大的时候，通常我们会忽略掉 O(n)，着手优化 O(n^2) 的部分

## 3.2 通过流水线提高性能

现代的工厂里的生产线叫“流水线”。

我们可以把装配iPhone这样的任务拆分成一个个细分的任务，让每个人都只需要处理一道工序，最大化整个工厂的生产效率。

我们的CPU其实就是一个“运算工厂”

我们把CPU指令执行的过程进行拆分，细化运行，也是现代CPU在主频没有办法提升那么多的情况下，性能仍然可以得到提升的重要原因之一

## 3.3 通过预测提高性能

预测下一步该干什么，而不是等上一步运行结果，提前进行运算，也是让程序跑得更快一点的办法

在一个循环访问数组的时候，凭经验，你也会猜到下一步我们会访问数组的下一项

后面要讲的“分支和冒险”、“局部性原理”这些CPU和存储系统设计方法，其实都是在利用我们对于未来的“预测”，提前进行相应的操作，来提升我们的程序性能。

> 深度优先搜索算法里面的 “剪枝策略”，防止没有必要的分支搜索，这会大幅度提升算法效率

- 整个组成乃至体系结构，都是基于冯·诺依曼架构组成的软硬件一体的解决方案
- 这里面的方方面面的设计和考虑，除了体系结构层面的抽象和通用性之外，核心需要考虑的是“性能”问题

# 参考

深入浅出计算机组成原理

# X 交流学习
![](https://img-blog.csdnimg.cn/20190504005601174.jpg)
## [Java交流群](https://jq.qq.com/?_wv=1027&k=5UB4P1T)
## [博客](https://blog.csdn.net/qq_33589510)
## [Github](https://github.com/Wasabi1234)
